/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.token;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.ITokenFactory;
import com.minecolonies.api.colony.requestsystem.token.StandardToken;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTokenFactory<I>
implements ITokenFactory<I, StandardToken> {
    public static final String NBT_MSB = "Id_MSB";
    public static final String NBT_LSB = "Id_LSB";

    @Override
    @NotNull
    public TypeToken<StandardToken> getFactoryOutputType() {
        return TypeConstants.STANDARDTOKEN;
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StandardToken request) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74772_a(NBT_LSB, request.getIdentifier().getLeastSignificantBits());
        compound.func_74772_a(NBT_MSB, request.getIdentifier().getMostSignificantBits());
        return compound;
    }

    @Override
    @NotNull
    public StandardToken deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        Long msb = nbt.func_74763_f(NBT_MSB);
        Long lsb = nbt.func_74763_f(NBT_LSB);
        UUID id = new UUID(msb, lsb);
        return new StandardToken(id);
    }

    @Override
    public void serialize(IFactoryController controller, StandardToken input, PacketBuffer packetBuffer) {
        packetBuffer.writeLong(input.getIdentifier().getLeastSignificantBits());
        packetBuffer.writeLong(input.getIdentifier().getMostSignificantBits());
    }

    @Override
    public StandardToken deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
        long lsb = buffer.readLong();
        long msb = buffer.readLong();
        UUID id = new UUID(msb, lsb);
        return new StandardToken(id);
    }
}

